/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crank;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class ValveHandleBlock
extends HandCrankBlock {
    public final DyeColor color;

    public static ValveHandleBlock copper(BlockBehaviour.Properties properties) {
        return new ValveHandleBlock(properties, null);
    }

    public static ValveHandleBlock dyed(BlockBehaviour.Properties properties, DyeColor color) {
        return new ValveHandleBlock(properties, color);
    }

    private ValveHandleBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.VALVE_HANDLE.get((Direction)pState.m_61143_((Property)FACING));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof ValveHandleBlock)) {
            return;
        }
        ValveHandleBlock vhb = (ValveHandleBlock)block;
        if (!player.m_36326_()) {
            return;
        }
        if (AllItems.WRENCH.isIn(player.m_21120_(event.getHand())) && player.m_6144_()) {
            return;
        }
        if (vhb.clicked(level, pos, blockState, player, event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(pNewState.m_60734_() instanceof ValveHandleBlock)) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public boolean clicked(Level level, BlockPos pos, BlockState blockState, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null && color != this.color) {
            if (!level.f_46443_) {
                level.m_46597_(pos, BlockHelper.copyProperties(blockState, AllBlocks.DYED_VALVE_HANDLES.get(color).getDefaultState()));
            }
            return true;
        }
        this.onBlockEntityUse((BlockGetter)level, pos, hcbe -> {
            ValveHandleBlockEntity vhbe;
            return hcbe instanceof ValveHandleBlockEntity && (vhbe = (ValveHandleBlockEntity)hcbe).activate(player.m_6144_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        });
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    public BlockEntityType<? extends HandCrankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.VALVE_HANDLE.get();
    }

    @Override
    public int getRotationSpeed() {
        return 32;
    }
}

