/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;

public class FactoryPanelConfigurationPacket
extends BlockEntityConfigurationPacket<FactoryPanelBlockEntity> {
    private FactoryPanelBlock.PanelSlot slot;
    private String address;
    private Map<FactoryPanelPosition, Integer> inputAmounts;
    private List<ItemStack> craftingArrangement;
    private int outputAmount;
    private int promiseClearingInterval;
    private FactoryPanelPosition removeConnection;
    private boolean clearPromises;
    private boolean reset;
    private boolean redstoneReset;

    public FactoryPanelConfigurationPacket(FactoryPanelPosition position, String address, Map<FactoryPanelPosition, Integer> inputAmounts, List<ItemStack> craftingArrangement, int outputAmount, int promiseClearingInterval, @Nullable FactoryPanelPosition removeConnection, boolean clearPromises, boolean reset, boolean sendRedstoneReset) {
        super(position.pos());
        this.address = address;
        this.inputAmounts = inputAmounts;
        this.craftingArrangement = craftingArrangement;
        this.outputAmount = outputAmount;
        this.promiseClearingInterval = promiseClearingInterval;
        this.removeConnection = removeConnection;
        this.clearPromises = clearPromises;
        this.reset = reset;
        this.redstoneReset = sendRedstoneReset;
        this.slot = position.slot();
    }

    public FactoryPanelConfigurationPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.slot.ordinal());
        buffer.m_130070_(this.address);
        buffer.m_130130_(this.inputAmounts.size());
        for (Map.Entry<FactoryPanelPosition, Integer> entry : this.inputAmounts.entrySet()) {
            entry.getKey().send(buffer);
            buffer.m_130130_(entry.getValue().intValue());
        }
        buffer.m_130130_(this.craftingArrangement.size());
        this.craftingArrangement.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        buffer.m_130130_(this.outputAmount);
        buffer.m_130130_(this.promiseClearingInterval);
        buffer.writeBoolean(this.removeConnection != null);
        if (this.removeConnection != null) {
            this.removeConnection.send(buffer);
        }
        buffer.writeBoolean(this.clearPromises);
        buffer.writeBoolean(this.reset);
        buffer.writeBoolean(this.redstoneReset);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.slot = FactoryPanelBlock.PanelSlot.values()[buffer.m_130242_()];
        this.address = buffer.m_130277_();
        this.inputAmounts = new HashMap<FactoryPanelPosition, Integer>();
        int entries = buffer.m_130242_();
        for (int i = 0; i < entries; ++i) {
            this.inputAmounts.put(FactoryPanelPosition.receive(buffer), buffer.m_130242_());
        }
        int craftEntries = buffer.m_130242_();
        this.craftingArrangement = new ArrayList<ItemStack>();
        for (int i = 0; i < craftEntries; ++i) {
            this.craftingArrangement.add(buffer.m_130267_());
        }
        this.outputAmount = buffer.m_130242_();
        this.promiseClearingInterval = buffer.m_130242_();
        if (buffer.readBoolean()) {
            this.removeConnection = FactoryPanelPosition.receive(buffer);
        }
        this.clearPromises = buffer.readBoolean();
        this.reset = buffer.readBoolean();
        this.redstoneReset = buffer.readBoolean();
    }

    @Override
    protected void applySettings(FactoryPanelBlockEntity be) {
        FactoryPanelBehaviour behaviour = be.panels.get((Object)this.slot);
        if (behaviour == null) {
            return;
        }
        behaviour.recipeAddress = this.reset ? "" : this.address;
        behaviour.recipeOutput = this.reset ? 1 : this.outputAmount;
        behaviour.promiseClearingInterval = this.reset ? -1 : this.promiseClearingInterval;
        List<Object> list = behaviour.activeCraftingArrangement = this.reset ? List.of() : this.craftingArrangement;
        if (this.reset) {
            behaviour.forceClearPromises = true;
            behaviour.disconnectAll();
            behaviour.setFilter(ItemStack.f_41583_);
            behaviour.count = 0;
            be.redraw = true;
            be.notifyUpdate();
            return;
        }
        if (this.redstoneReset) {
            behaviour.disconnectAllLinks();
            be.notifyUpdate();
            return;
        }
        for (Map.Entry<FactoryPanelPosition, Integer> entry : this.inputAmounts.entrySet()) {
            FactoryPanelPosition key = entry.getKey();
            FactoryPanelConnection connection = behaviour.targetedBy.get(key);
            if (connection == null) continue;
            connection.amount = entry.getValue();
        }
        if (this.removeConnection != null) {
            behaviour.targetedBy.remove(this.removeConnection);
            FactoryPanelBehaviour source = FactoryPanelBehaviour.at((BlockAndTintGetter)be.m_58904_(), this.removeConnection);
            if (source != null) {
                source.targeting.remove(behaviour.getPanelPosition());
                source.blockEntity.sendData();
            }
        }
        if (this.clearPromises) {
            behaviour.forceClearPromises = true;
        }
        be.notifyUpdate();
    }
}

