/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelFilterSlotPositioning;
import com.simibubi.create.content.logistics.funnel.FunnelFlapPacket;
import com.simibubi.create.content.redstone.smartObserver.SmartObserverBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.BlockFace;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class FunnelBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour invManipulation;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private int extractionCooldown = 0;
    private WeakReference<Entity> lastObserved;
    LerpedFloat flap = this.createChasingFlap();
    static final AABB coreBB = new AABB(BlockPos.f_121853_);

    public FunnelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public Mode determineCurrentMode() {
        BlockState state = this.m_58900_();
        if (!FunnelBlock.isFunnel(state)) {
            return Mode.INVALID;
        }
        if (state.m_61145_((Property)BlockStateProperties.f_61448_).orElse(false).booleanValue()) {
            return Mode.PAUSED;
        }
        if (state.m_60734_() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.m_61143_(BeltFunnelBlock.SHAPE));
            if (shape == BeltFunnelBlock.Shape.PULLING) {
                return Mode.TAKING_FROM_BELT;
            }
            if (shape == BeltFunnelBlock.Shape.PUSHING) {
                return Mode.PUSHING_TO_BELT;
            }
            BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)this.f_58857_, this.f_58858_.m_7495_());
            if (belt != null) {
                return belt.getMovementFacing() == state.m_61143_((Property)BeltFunnelBlock.HORIZONTAL_FACING) ? Mode.PUSHING_TO_BELT : Mode.TAKING_FROM_BELT;
            }
            return Mode.INVALID;
        }
        if (state.m_60734_() instanceof FunnelBlock) {
            return (Boolean)state.m_61143_((Property)FunnelBlock.EXTRACTING) != false ? Mode.EXTRACT : Mode.COLLECT;
        }
        return Mode.INVALID;
    }

    @Override
    public void tick() {
        super.tick();
        this.flap.tickChaser();
        Mode mode = this.determineCurrentMode();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (mode == Mode.PAUSED) {
            this.extractionCooldown = 0;
        }
        if (mode == Mode.TAKING_FROM_BELT) {
            return;
        }
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        if (mode == Mode.PUSHING_TO_BELT) {
            this.activateExtractingBeltFunnel();
        }
        if (mode == Mode.EXTRACT) {
            this.activateExtractor();
        }
    }

    private void activateExtractor() {
        if (this.invVersionTracker.stillWaiting(this.invManipulation)) {
            return;
        }
        BlockState blockState = this.m_58900_();
        Direction facing = AbstractFunnelBlock.getFunnelFacing(blockState);
        if (facing == null) {
            return;
        }
        boolean trackingEntityPresent = true;
        AABB area = this.getEntityOverflowScanningArea();
        if (this.lastObserved == null) {
            trackingEntityPresent = false;
        } else {
            Entity lastEntity = (Entity)this.lastObserved.get();
            if (lastEntity == null || !lastEntity.m_6084_() || !lastEntity.m_20191_().m_82381_(area)) {
                trackingEntityPresent = false;
                this.lastObserved = null;
            }
        }
        if (trackingEntityPresent) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemHelper.ExtractionCountMode mode = this.getModeToExtract();
        ItemStack stack = ((InvManipulationBehaviour)this.invManipulation.simulate()).extract(mode, amountToExtract);
        if (stack.m_41619_()) {
            this.invVersionTracker.awaitNewVersion(this.invManipulation);
            return;
        }
        for (Entity entity : this.f_58857_.m_45933_(null, area)) {
            if (!(entity instanceof ItemEntity) && !(entity instanceof PackageEntity)) continue;
            this.lastObserved = new WeakReference<Entity>(entity);
            return;
        }
        stack = this.invManipulation.extract(mode, amountToExtract);
        if (stack.m_41619_()) {
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        Vec3 outputPos = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        boolean vertical = facing.m_122434_().m_122478_();
        boolean up = facing == Direction.UP;
        outputPos = outputPos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(vertical ? (up ? (double)0.15f : 0.5) : 0.25));
        if (!vertical) {
            outputPos = outputPos.m_82492_(0.0, (double)0.45f, 0.0);
        }
        Vec3 motion = Vec3.f_82478_;
        if (up) {
            motion = new Vec3(0.0, 0.25, 0.0);
        }
        ItemEntity item = new ItemEntity(this.f_58857_, outputPos.f_82479_, outputPos.f_82480_, outputPos.f_82481_, stack.m_41777_());
        item.m_32060_();
        item.m_20256_(motion);
        this.f_58857_.m_7967_((Entity)item);
        this.lastObserved = new WeakReference<ItemEntity>(item);
        this.startCooldown();
    }

    private AABB getEntityOverflowScanningArea() {
        Direction facing = AbstractFunnelBlock.getFunnelFacing(this.m_58900_());
        AABB bb = coreBB.m_82338_(this.f_58858_);
        if (facing == null || facing == Direction.UP) {
            return bb;
        }
        return bb.m_82363_(0.0, -1.0, 0.0);
    }

    private void activateExtractingBeltFunnel() {
        MutableBoolean deniedByInsertion;
        if (this.invVersionTracker.stillWaiting(this.invManipulation)) {
            return;
        }
        BlockState blockState = this.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)BeltFunnelBlock.HORIZONTAL_FACING);
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((BlockGetter)this.f_58857_, this.f_58858_.m_7495_(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        if (!inputBehaviour.canInsertFromSide(facing)) {
            return;
        }
        if (inputBehaviour.isOccupied(facing)) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemHelper.ExtractionCountMode mode = this.getModeToExtract();
        ItemStack stack = this.invManipulation.extract(mode, amountToExtract, arg_0 -> FunnelBlockEntity.lambda$activateExtractingBeltFunnel$0(inputBehaviour, facing, deniedByInsertion = new MutableBoolean(false), arg_0));
        if (stack.m_41619_()) {
            if (deniedByInsertion.isFalse()) {
                this.invVersionTracker.awaitNewVersion((IItemHandler)this.invManipulation.getInventory());
            }
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        inputBehaviour.handleInsertion(stack, facing, false);
        this.startCooldown();
    }

    public int getAmountToExtract() {
        if (!this.supportsAmountOnFilter()) {
            return 64;
        }
        int amountToExtract = this.invManipulation.getAmountFromFilter();
        if (!this.filtering.isActive()) {
            amountToExtract = 1;
        }
        return amountToExtract;
    }

    public ItemHelper.ExtractionCountMode getModeToExtract() {
        if (!this.supportsAmountOnFilter() || !this.filtering.isActive()) {
            return ItemHelper.ExtractionCountMode.UPTO;
        }
        return this.invManipulation.getModeFromFilter();
    }

    private int startCooldown() {
        this.extractionCooldown = (Integer)AllConfigs.server().logistics.defaultExtractionTimer.get();
        return this.extractionCooldown;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.invManipulation = new InvManipulationBehaviour(this, (w, p, s) -> new BlockFace(p, AbstractFunnelBlock.getFunnelFacing(s).m_122424_()));
        behaviours.add(this.invManipulation);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        this.filtering = new FilteringBehaviour(this, new FunnelFilterSlotPositioning());
        this.filtering.showCountWhen(this::supportsAmountOnFilter);
        this.filtering.onlyActiveWhen(this::supportsFiltering);
        this.filtering.withCallback($ -> this.invVersionTracker.reset());
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput).setInsertionHandler(this::handleDirectBeltInput));
        this.registerAwardables(behaviours, AllAdvancements.FUNNEL);
    }

    private boolean supportsAmountOnFilter() {
        BlockState blockState = this.m_58900_();
        boolean beltFunnelsupportsAmount = false;
        if (blockState.m_60734_() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)blockState.m_61143_(BeltFunnelBlock.SHAPE));
            beltFunnelsupportsAmount = shape == BeltFunnelBlock.Shape.PUSHING ? true : BeltHelper.getSegmentBE((LevelAccessor)this.f_58857_, this.f_58858_.m_7495_()) != null;
        }
        boolean extractor = blockState.m_60734_() instanceof FunnelBlock && (Boolean)blockState.m_61143_((Property)FunnelBlock.EXTRACTING) != false;
        return beltFunnelsupportsAmount || extractor;
    }

    private boolean supportsDirectBeltInput(Direction side) {
        BlockState blockState = this.m_58900_();
        if (blockState == null) {
            return false;
        }
        if (!(blockState.m_60734_() instanceof FunnelBlock)) {
            return false;
        }
        if (((Boolean)blockState.m_61143_((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            return false;
        }
        return FunnelBlock.getFunnelFacing(blockState) == Direction.UP;
    }

    private boolean supportsFiltering() {
        BlockState blockState = this.m_58900_();
        return AllBlocks.BRASS_BELT_FUNNEL.has(blockState) || AllBlocks.BRASS_FUNNEL.has(blockState);
    }

    private ItemStack handleDirectBeltInput(TransportedItemStack stack, Direction side, boolean simulate) {
        ItemStack inserted = stack.stack;
        if (!this.filtering.test(inserted)) {
            return inserted;
        }
        if (this.determineCurrentMode() == Mode.PAUSED) {
            return inserted;
        }
        if (simulate) {
            this.invManipulation.simulate();
        }
        if (!simulate) {
            this.onTransfer(inserted);
        }
        return this.invManipulation.insert(inserted);
    }

    public void flap(boolean inward) {
        if (!this.f_58857_.f_46443_) {
            AllPackets.getChannel().send(this.packetTarget(), (Object)new FunnelFlapPacket(this, inward));
        } else {
            this.flap.setValue(inward ? -1.0 : 1.0);
            AllSoundEvents.FUNNEL_FLAP.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f, true);
        }
    }

    public boolean hasFlap() {
        BlockState blockState = this.m_58900_();
        return AbstractFunnelBlock.getFunnelFacing(blockState).m_122434_().m_122479_();
    }

    public float getFlapOffset() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof BeltFunnelBlock)) {
            return -0.0625f;
        }
        switch ((BeltFunnelBlock.Shape)((Object)blockState.m_61143_(BeltFunnelBlock.SHAPE))) {
            default: {
                return 0.0f;
            }
            case EXTENDED: {
                return 0.5f;
            }
            case PULLING: 
            case PUSHING: 
        }
        return -0.125f;
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("TransferCooldown", this.extractionCooldown);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.extractionCooldown = compound.m_128451_("TransferCooldown");
        if (clientPacket) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }

    public void onTransfer(ItemStack stack) {
        ((SmartObserverBlock)AllBlocks.SMART_OBSERVER.get()).onFunnelTransfer(this.f_58857_, this.f_58858_, stack);
        this.award(AllAdvancements.FUNNEL);
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, (double)0.05f, LerpedFloat.Chaser.EXP);
    }

    private static /* synthetic */ boolean lambda$activateExtractingBeltFunnel$0(DirectBeltInputBehaviour inputBehaviour, Direction facing, MutableBoolean deniedByInsertion, ItemStack s) {
        ItemStack handleInsertion = inputBehaviour.handleInsertion(s, facing, true);
        if (handleInsertion.m_41619_()) {
            return true;
        }
        deniedByInsertion.setTrue();
        return false;
    }

    static enum Mode {
        INVALID,
        PAUSED,
        COLLECT,
        PUSHING_TO_BELT,
        TAKING_FROM_BELT,
        EXTRACT;

    }
}

