/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantAttribute
implements ItemAttribute {
    @Nullable
    private Enchantment enchantment;

    public EnchantAttribute(@Nullable Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(this.enchantment);
    }

    @Override
    public String getTranslationKey() {
        return "has_enchant";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.enchantment != null) {
            parameter = Component.m_237115_((String)this.enchantment.m_44704_()).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_ENCHANT;
    }

    @Override
    public void save(CompoundTag nbt) {
        if (this.enchantment == null) {
            return;
        }
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((Object)this.enchantment);
        if (id == null) {
            return;
        }
        NBTHelper.writeResourceLocation((CompoundTag)nbt, (String)"enchantId", (ResourceLocation)id);
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("enchantId")) {
            this.enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(NBTHelper.readResourceLocation((CompoundTag)nbt, (String)"enchantId"));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new EnchantAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
                list.add(new EnchantAttribute(enchantment));
            }
            return list;
        }
    }
}

