/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.basin;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BasinBlock
extends Block
implements IBE<BasinBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;

    public BasinBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_.m_61104_(new Property[]{FACING}));
    }

    public static boolean isBasin(LevelReader world, BlockPos pos) {
        return world.m_7702_(pos) instanceof BasinBlockEntity;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
        return !(blockEntity instanceof BasinOperatingBlockEntity);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), bte -> bte.onWrenched(context.m_43719_()));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            if (!heldItem.m_41619_()) {
                if (FluidHelper.tryEmptyItemIntoBE(worldIn, player, handIn, heldItem, be)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE(worldIn, player, handIn, heldItem, be)) {
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied(worldIn, heldItem) || GenericItemFilling.canItemBeFilled(worldIn, heldItem)) {
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_().equals(Items.f_41902_) && !be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> iFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty()) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)be.itemCapability.orElse((Object)new ItemStackHandler(1));
            boolean success = false;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.m_41619_()) continue;
                player.m_150109_().m_150079_(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.f_41583_);
                success = true;
            }
            if (success) {
                worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            }
            be.onEmptied();
            return InteractionResult.SUCCESS;
        });
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!worldIn.m_8055_(entityIn.m_20183_()).m_60713_((Block)this)) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.m_6084_()) {
            return;
        }
        this.withBlockEntityDo(worldIn, entityIn.m_20183_(), be -> {
            ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)be.inputInventory, (ItemStack)itemEntity.m_32055_().m_41777_(), (boolean)false);
            if (insertItem.m_41619_()) {
                itemEntity.m_146870_();
                return;
            }
            itemEntity.m_32045_(insertItem);
        });
    }

    public VoxelShape m_6079_(BlockState p_199600_1_, BlockGetter p_199600_2_, BlockPos p_199600_3_) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        if (ctx instanceof EntityCollisionContext && ((EntityCollisionContext)ctx).m_193113_() instanceof ItemEntity) {
            return AllShapes.BASIN_COLLISION_SHAPE;
        }
        return this.m_5940_(state, reader, pos, ctx);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove(state, worldIn, pos, newState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(BasinBlockEntity::getInputInventory).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Override
    public Class<BasinBlockEntity> getBlockEntityClass() {
        return BasinBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends BasinBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.BASIN.get();
    }

    public static boolean canOutputTo(BlockGetter world, BlockPos basinPos, Direction direction) {
        DirectBeltInputBehaviour directBeltInputBehaviour;
        BlockPos neighbour = basinPos.m_121945_(direction);
        BlockPos output = neighbour.m_7495_();
        BlockState blockState = world.m_8055_(neighbour);
        if (FunnelBlock.isFunnel(blockState)) {
            if (FunnelBlock.getFunnelFacing(blockState) == direction) {
                return false;
            }
        } else {
            if (!blockState.m_60812_(world, neighbour).m_83281_()) {
                return false;
            }
            BlockEntity blockEntity = world.m_7702_(output);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return belt.getSpeed() == 0.0f || belt.getMovementFacing() != direction.m_122424_();
            }
        }
        if ((directBeltInputBehaviour = BlockEntityBehaviour.get(world, output, DirectBeltInputBehaviour.TYPE)) != null) {
            return directBeltInputBehaviour.canInsertFromSide(direction);
        }
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

