/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationEditPacket;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.content.trains.station.WideIconButton;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AssemblyScreen
extends AbstractStationScreen {
    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<ResourceLocation> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        int by = y + this.background.getHeight() - 24;
        Renderable widget = (Renderable)this.f_169369_.get(0);
        if (widget instanceof IconButton) {
            IconButton ib = (IconButton)widget;
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip((Component)CreateLang.translateDirect("station.close", new Object[0]));
        }
        this.iconTypes = TrainIconType.REGISTRY.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 162, 14).titled(CreateLang.translateDirect("station.icon_type", new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -this.iconTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId(this.iconTypes.get((int)s));
            }
        });
        this.iconTypeScroll.f_93624_ = false;
        this.iconTypeScroll.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.iconTypeScroll);
        this.toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        this.toggleAssemblyButton.f_93623_ = false;
        this.toggleAssemblyButton.setToolTip((Component)CreateLang.translateDirect("station.assemble_train", new Object[0]));
        this.toggleAssemblyButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)StationEditPacket.tryAssemble(this.blockEntity.m_58899_())));
        this.quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        this.quitAssembly.f_93623_ = true;
        this.quitAssembly.setToolTip((Component)CreateLang.translateDirect("station.cancel", new Object[0]));
        this.quitAssembly.withCallback(() -> {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
        });
        this.m_142416_((GuiEventListener)this.toggleAssemblyButton);
        this.m_142416_((GuiEventListener)this.quitAssembly);
        this.tickTrainDisplay();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.tickTrainDisplay();
        Train train = (Train)this.displayedTrain.get();
        boolean bl = this.toggleAssemblyButton.f_93623_ = this.blockEntity.bogeyCount > 0 || train != null;
        if (train != null) {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
            for (Carriage carriage : train.carriages) {
                carriage.updateConductors();
            }
        }
    }

    private void tickTrainDisplay() {
        if (this.getImminent() == null) {
            this.displayedTrain = new WeakReference<Object>(null);
            this.quitAssembly.f_93623_ = true;
            this.iconTypeScroll.f_93624_ = false;
            this.iconTypeScroll.f_93623_ = false;
            this.toggleAssemblyButton.setToolTip((Component)CreateLang.translateDirect("station.assemble_train", new Object[0]));
            this.toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            this.toggleAssemblyButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)StationEditPacket.tryAssemble(this.blockEntity.m_58899_())));
        } else {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        MutableComponent header = CreateLang.translateDirect("station.assembly_title", new Object[0]);
        graphics.m_280614_(this.f_96547_, (Component)header, x + this.background.getWidth() / 2 - this.f_96547_.m_92852_((FormattedText)header) / 2, y + 4, 926259, false);
        AssemblyException lastAssemblyException = this.blockEntity.lastException;
        if (lastAssemblyException != null) {
            MutableComponent text = CreateLang.translateDirect("station.failed", new Object[0]);
            graphics.m_280614_(this.f_96547_, (Component)text, x + 97 - this.f_96547_.m_92852_((FormattedText)text) / 2, y + 47, 0x775B5B, false);
            int offset = 0;
            if (this.blockEntity.failedCarriageIndex != -1) {
                graphics.m_280614_(this.f_96547_, (Component)CreateLang.translateDirect("station.carriage_number", this.blockEntity.failedCarriageIndex), x + 30, y + 67, 0x7A7A7A, false);
                offset += 10;
            }
            graphics.m_280554_(this.f_96547_, (FormattedText)lastAssemblyException.component, x + 30, y + 67 + offset, 134, 0x775B5B);
            graphics.m_280554_(this.f_96547_, (FormattedText)CreateLang.translateDirect("station.retry", new Object[0]), x + 30, y + 67 + (offset += this.f_96547_.m_92923_((FormattedText)lastAssemblyException.component, 134).size() * 9 + 5), 134, 0x7A7A7A);
            return;
        }
        int bogeyCount = this.blockEntity.bogeyCount;
        MutableComponent text = CreateLang.translateDirect(bogeyCount == 0 ? "station.no_bogeys" : (bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys"), bogeyCount);
        graphics.m_280614_(this.f_96547_, (Component)text, x + 97 - this.f_96547_.m_92852_((FormattedText)text) / 2, y + 47, 0x7A7A7A, false);
        graphics.m_280554_(this.f_96547_, (FormattedText)CreateLang.translateDirect("station.how_to", new Object[0]), x + 28, y + 62, 134, 0x7A7A7A);
        graphics.m_280554_(this.f_96547_, (FormattedText)CreateLang.translateDirect("station.how_to_1", new Object[0]), x + 28, y + 94, 134, 0x7A7A7A);
        graphics.m_280554_(this.f_96547_, (FormattedText)CreateLang.translateDirect("station.how_to_2", new Object[0]), x + 28, y + 117, 138, 0x7A7A7A);
    }

    public void m_7861_() {
        super.m_7861_();
        Train train = (Train)this.displayedTrain.get();
        if (train != null) {
            ResourceLocation iconId = this.iconTypes.get(this.iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            AllPackets.getChannel().sendToServer((Object)new TrainEditPacket(train.id, "", iconId, train.mapColorIndex));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllPartialModels.STATION_ASSEMBLE;
    }
}

