/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.foundation.particle.AirParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<AirParticleData> {
    public static final Codec<AirParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("drag").forGetter(p -> Float.valueOf(p.drag)), (App)Codec.FLOAT.fieldOf("speed").forGetter(p -> Float.valueOf(p.speed))).apply((Applicative)i, AirParticleData::new));
    public static final ParticleOptions.Deserializer<AirParticleData> DESERIALIZER = new ParticleOptions.Deserializer<AirParticleData>(){

        public AirParticleData fromCommand(ParticleType<AirParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float drag = reader.readFloat();
            reader.expect(' ');
            float speed = reader.readFloat();
            return new AirParticleData(drag, speed);
        }

        public AirParticleData fromNetwork(ParticleType<AirParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new AirParticleData(buffer.readFloat(), buffer.readFloat());
        }
    };
    float drag;
    float speed;

    public AirParticleData(float drag, float speed) {
        this.drag = drag;
        this.speed = speed;
    }

    public AirParticleData() {
        this(0.0f, 0.0f);
    }

    public ParticleType<?> m_6012_() {
        return AllParticleTypes.AIR.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.drag);
        buffer.writeFloat(this.speed);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %f %f", AllParticleTypes.AIR.parameter(), Float.valueOf(this.drag), Float.valueOf(this.speed));
    }

    @Override
    public ParticleOptions.Deserializer<AirParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<AirParticleData> getCodec(ParticleType<AirParticleData> type) {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<AirParticleData> getMetaFactory() {
        return AirParticle.Factory::new;
    }
}

