/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.Nullable;

public class TextComponentParser {
    public static final Char2ObjectOpenHashMap<ChatFormatting> CODE_TO_FORMATTING = new Char2ObjectOpenHashMap();
    private final String text;
    private final Function<String, Component> substitutes;
    private MutableComponent component;
    private StringBuilder builder;
    private Style style;

    public static Component parse(String text, @Nullable Function<String, Component> substitutes) {
        Component c = TextComponentParser.parse0(text, substitutes);
        if (c == Component.f_130760_) {
            return c;
        }
        while (c.m_214077_() == ComponentContents.f_237124_ && c.m_7383_().equals((Object)Style.f_131099_) && c.m_7360_().size() == 1) {
            c = (Component)c.m_7360_().get(0);
        }
        return c;
    }

    private static Component parse0(String text, @Nullable Function<String, Component> substitutes) {
        try {
            return new TextComponentParser(text, substitutes).parse();
        }
        catch (BadFormatException ex) {
            return Component.m_237113_((String)ex.getMessage()).m_130940_(ChatFormatting.RED);
        }
        catch (Exception ex) {
            return Component.m_237113_((String)ex.toString()).m_130940_(ChatFormatting.RED);
        }
    }

    private TextComponentParser(String txt, @Nullable Function<String, Component> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    private Component parse() throws BadFormatException {
        if (this.text.isEmpty()) {
            return Component.m_237119_();
        }
        char[] c = this.text.replaceAll("\\\\n", "\n").toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return Component.m_237113_((String)new String(c));
        }
        this.component = Component.m_237113_((String)"");
        this.style = Style.f_131099_;
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new BadFormatException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                if (c[i] == '&' || c[i] == '\u00a7') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with &!");
                    }
                    if (c[++i] == '#') {
                        char[] rrggbb = new char[7];
                        rrggbb[0] = 35;
                        System.arraycopy(c, i + 1, rrggbb, 1, 6);
                        i += 6;
                        this.style = this.style.m_131148_(TextColor.m_131268_((String)new String(rrggbb)));
                        continue;
                    }
                    if (c[i] == ' ') {
                        throw new BadFormatException("Invalid formatting! You must escape whitespace after & with \\&!");
                    }
                    ChatFormatting formatting = (ChatFormatting)CODE_TO_FORMATTING.get(c[i]);
                    if (formatting == null) {
                        throw new BadFormatException("Invalid formatting! Unknown formatting symbol after &: '" + c[i] + "'!");
                    }
                    this.style = this.style.m_131157_(formatting);
                    continue;
                }
                if (c[i] == '{') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with {!");
                    }
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() throws BadFormatException {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        if (string.length() < 2 || string.charAt(0) != '{') {
            MutableComponent component1 = Component.m_237113_((String)string);
            component1.m_6270_(this.style);
            this.component.m_7220_((Component)component1);
            return;
        }
        Component component1 = this.substitutes.apply(string.substring(1));
        if (component1 == null) {
            throw new BadFormatException("Invalid formatting! Unknown substitute: " + string.substring(1));
        }
        Style style0 = component1.m_7383_();
        Style style1 = this.style;
        style1 = style1.m_131144_(style0.m_131186_());
        style1 = style1.m_131142_(style0.m_131182_());
        style1 = style1.m_131138_(style0.m_131189_());
        component1 = Component.m_237113_((String)"").m_7220_(component1).m_130948_(style1);
        this.component.m_7220_(component1);
    }

    static {
        CODE_TO_FORMATTING.put('0', (Object)ChatFormatting.BLACK);
        CODE_TO_FORMATTING.put('1', (Object)ChatFormatting.DARK_BLUE);
        CODE_TO_FORMATTING.put('2', (Object)ChatFormatting.DARK_GREEN);
        CODE_TO_FORMATTING.put('3', (Object)ChatFormatting.DARK_AQUA);
        CODE_TO_FORMATTING.put('4', (Object)ChatFormatting.DARK_RED);
        CODE_TO_FORMATTING.put('5', (Object)ChatFormatting.DARK_PURPLE);
        CODE_TO_FORMATTING.put('6', (Object)ChatFormatting.GOLD);
        CODE_TO_FORMATTING.put('7', (Object)ChatFormatting.GRAY);
        CODE_TO_FORMATTING.put('8', (Object)ChatFormatting.DARK_GRAY);
        CODE_TO_FORMATTING.put('9', (Object)ChatFormatting.BLUE);
        CODE_TO_FORMATTING.put('a', (Object)ChatFormatting.GREEN);
        CODE_TO_FORMATTING.put('b', (Object)ChatFormatting.AQUA);
        CODE_TO_FORMATTING.put('c', (Object)ChatFormatting.RED);
        CODE_TO_FORMATTING.put('d', (Object)ChatFormatting.LIGHT_PURPLE);
        CODE_TO_FORMATTING.put('e', (Object)ChatFormatting.YELLOW);
        CODE_TO_FORMATTING.put('f', (Object)ChatFormatting.WHITE);
        CODE_TO_FORMATTING.put('k', (Object)ChatFormatting.OBFUSCATED);
        CODE_TO_FORMATTING.put('l', (Object)ChatFormatting.BOLD);
        CODE_TO_FORMATTING.put('m', (Object)ChatFormatting.STRIKETHROUGH);
        CODE_TO_FORMATTING.put('n', (Object)ChatFormatting.UNDERLINE);
        CODE_TO_FORMATTING.put('o', (Object)ChatFormatting.ITALIC);
        CODE_TO_FORMATTING.put('r', (Object)ChatFormatting.RESET);
    }

    private static class BadFormatException
    extends IllegalArgumentException {
        private BadFormatException(String s) {
            super(s);
        }
    }
}

