/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
implements MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("custom_type").forGetter(CustomDecorationType::getCustomFactoryID)).apply((Applicative)instance, MapDataRegistry::getCustomType));
    @ApiStatus.Internal
    public ResourceLocation factoryId;
    private final BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory;
    @NotNull
    private final Function<CustomDecorationType<D, M>, M> markerFactory;
    @Nullable
    private final BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory;

    private CustomDecorationType(ResourceLocation typeId, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory, Function<CustomDecorationType<D, M>, M> markerFactory, @Nullable BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory) {
        this.factoryId = typeId;
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
    }

    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> withWorldMarker(Function<CustomDecorationType<D, M>, M> markerFactory, @Nullable BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType<D, M>(null, decorationFactory, markerFactory, markerFromWorldFactory);
    }

    @Deprecated(forRemoval=true)
    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> withWorldMarker(ResourceLocation typeId, Supplier<M> markerFactory, @Nullable BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType<D, MapBlockMarker>(typeId, decorationFactory, t -> (MapBlockMarker)markerFactory.get(), markerFromWorldFactory);
    }

    @Deprecated(forRemoval=true)
    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> simple(ResourceLocation typeId, Supplier<M> markerFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType<D, MapBlockMarker>(typeId, decorationFactory, t -> (MapBlockMarker)markerFactory.get(), null);
    }

    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> simple(Function<CustomDecorationType<D, M>, M> markerFactory, BiFunction<MapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        return new CustomDecorationType<D, M>(null, decorationFactory, markerFactory, null);
    }

    @Override
    public ResourceLocation getCustomFactoryID() {
        return this.factoryId;
    }

    @Override
    public boolean isFromWorld() {
        return this.markerFromWorldFactory != null;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + String.valueOf(this) + ": " + String.valueOf(e));
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(CompoundTag compound) {
        MapBlockMarker marker = (MapBlockMarker)this.markerFactory.apply(this);
        try {
            marker.loadFromNBT(compound);
            return (M)marker;
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + String.valueOf(this) + ": " + String.valueOf(e));
            return null;
        }
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        return (M)(this.markerFromWorldFactory != null ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }

    @Override
    public M createEmptyMarker() {
        return (M)((MapBlockMarker)this.markerFactory.apply(this));
    }
}

