/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common;

import com.illusivesoulworks.colytra.common.CommonEvents;
import java.util.UUID;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.caelus.api.CaelusApi;

public class CommonEventsListener {
    private static final AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("668bdbee-32b6-4c4b-bf6a-5a30f4d02e37"), "Flight modifier", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onColytraAnvil(AnvilUpdateEvent evt) {
        Triple<ItemStack, Integer, Integer> result = CommonEvents.repairColytra(evt.getLeft(), evt.getRight(), evt.getName());
        if (!((ItemStack)result.getLeft()).m_41619_()) {
            evt.setOutput((ItemStack)result.getLeft());
            evt.setMaterialCost(((Integer)result.getMiddle()).intValue());
            evt.setCost(((Integer)result.getRight()).intValue());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side != LogicalSide.SERVER || evt.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = evt.player;
        AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        if (attributeInstance != null) {
            attributeInstance.m_22130_(FLIGHT_MODIFIER);
            if (CommonEvents.updateColytra((LivingEntity)player, true)) {
                attributeInstance.m_22118_(FLIGHT_MODIFIER);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerXpEvent.PickupXp evt) {
        ExperienceOrb orb = evt.getOrb();
        if (CommonEvents.repairColytraWithXp(orb, evt.getEntity(), val -> {
            orb.f_20770_ = val;
        })) {
            evt.setCanceled(true);
        }
    }
}

