/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.models;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.fml.ModList;
import tallestegg.guardvillagers.ModCompat;
import tallestegg.guardvillagers.entities.Guard;

public class GuardModel
extends HumanoidModel<Guard> {
    public ModelPart Nose;
    public ModelPart quiver;
    public ModelPart ArmLShoulderPad;
    public ModelPart ArmRShoulderPad;

    public GuardModel(ModelPart part) {
        super(part);
        this.Nose = this.f_102808_.m_171324_("nose");
        this.quiver = this.f_102810_.m_171324_("quiver");
        this.ArmLShoulderPad = this.f_102811_.m_171324_("shoulderPad_left");
        this.ArmRShoulderPad = this.f_102812_.m_171324_("shoulderPad_right");
        this.setRotateAngle(this.quiver, 0.0f, 0.0f, 0.2617994f);
        this.setRotateAngle(this.ArmLShoulderPad, 0.0f, 0.0f, -0.34906584f);
        this.setRotateAngle(this.ArmRShoulderPad, 0.0f, 0.0f, 0.34906584f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition torso = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(52, 50).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(49, 99).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 75).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(33, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        torso.m_171599_("quiver", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)3.0f, (float)2.3f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        leftArm.m_171599_("shoulderPad_right", CubeListBuilder.m_171558_().m_171514_(72, 33).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-3.5f, (float)0.0f));
        rightArm.m_171599_("shoulderPad_left", CubeListBuilder.m_171558_().m_171514_(72, 33).m_171488_(-5.0f, 0.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-3.5f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -11.0f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }

    public void setupAnim(Guard entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        boolean isHoldingShootable;
        super.m_6973_((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
        ItemStack itemstack = entityIn.m_21120_(InteractionHand.MAIN_HAND);
        this.quiver.f_104207_ = isHoldingShootable = itemstack.m_41720_() instanceof ProjectileWeaponItem || ModList.get().isLoaded("musketmod") && ModCompat.isHoldingMusket(itemstack);
        boolean hasChestplate = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem;
        this.ArmLShoulderPad.f_104207_ = !hasChestplate;
        boolean bl = this.ArmRShoulderPad.f_104207_ = !hasChestplate;
        if (entityIn.getKickTicks() > 0) {
            float f1 = 1.0f - (float)Mth.m_14040_((int)(10 - 2 * entityIn.getKickTicks())) / 10.0f;
            this.f_102813_.f_104203_ = Mth.m_14179_((float)f1, (float)this.f_102813_.f_104203_, (float)-1.4f);
        }
        double speed = 0.005;
        if (this.f_102608_ == 0.0f && entityIn.m_5912_() && !isHoldingShootable && entityIn.m_20184_().m_165925_() > speed && !entityIn.m_21205_().m_41619_() && !entityIn.m_21254_()) {
            this.holdWeaponHigh(entityIn);
        }
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    public void eatingAnimationRightHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.f_102811_.f_104204_ = -0.5f;
            this.f_102811_.f_104203_ = -1.3f;
            this.f_102811_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }

    public void eatingAnimationLeftHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.f_102812_.f_104204_ = 0.5f;
            this.f_102812_.f_104203_ = -1.3f;
            this.f_102812_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }

    private void holdWeaponHigh(Guard pMob) {
        if (pMob.m_21526_()) {
            this.f_102812_.f_104203_ = -1.8f;
        } else {
            this.f_102811_.f_104203_ = -1.8f;
        }
    }
}

